<?php $__env->startSection('title', 'Payment Agents'); ?>

<?php $__env->startSection('heading', 'Payment Agents'); ?>

<?php $__env->startSection('content'); ?>
    <?php echo $__env->make('partials._messages', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('add-payment_agent', $user)): ?>
        <a class="btn btn-secondary" href="<?php echo e(route('payment_agent.create')); ?>">Add Payment Agent</a>
    <?php endif; ?>

    <hr>
    <table class="table">
        <thead>
            <tr>
                <th>Agent</th>
                <th>Email</th>
                <th>Status</th>
                <th>Environment</th>
                <th>Created</th>
                <th></th>
            </tr>
        </thead>
        <tbody>
            <?php $__currentLoopData = $payment_agents; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $k => $P): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <tr>
                    <td><?php echo e($P->name); ?></td>
                    <td><?php echo e($P->email); ?></td>
                    <td>
                        <span class="<?php echo e($P->text_class($P->api_token_status)); ?>">
                            <?php echo e($P->status($P->api_token_status)); ?>

                        </span>
                    </td>
                    <td> <span class="<?php echo e($P->text_class($P->environment)); ?>"><?php echo e($P->environment); ?></span></td>
                    <td><?php echo e($P->created_at); ?></td>
                    <td class="text-center">
                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('view-token', $user)): ?>
                            <button class="btn btn-info"
                                onclick="populate_modal('<?php echo e($P->name); ?>','<?php echo e($P->api_token ? $P->api_token : 'Token Missing'); ?>')"
                                data-bs-toggle="modal" data-bs-target="#exampleModal">View Token</button>
                        <?php endif; ?>
                        <a class="btn btn-primary" href="<?php echo e(route('payment_agent.edit', $P->id)); ?>">Edit</a>
                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('delete-payment_agent', $user)): ?>
                            <form method="POST" style="display:inline;" action="<?php echo e(route('payment_agent.delete', $P->id)); ?>">
                                <?php echo csrf_field(); ?>
                                <?php echo method_field('DELETE'); ?>
                                <button type="submit" class="btn btn-danger"
                                    onclick="confirm('Are you sure you want to delete this item?')">Delete</button>
                            </form>
                        <?php endif; ?>
                    </td>
                </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tbody>
    </table>

    <!-- Modal -->
    <div class="modal fade " id="exampleModal" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered modal-xl">
            <div class="modal-content">
                <div class="modal-header">
                    <h3 class="modal-title" id="payment_agent"></h3>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <div class="alert alert-danger" role="alert">

                        <b><i data-feather="alert-triangle"></i> Warning</b> : This is confidential and should
                        only be shared with the payment agent.
                    </div>

                    <table class="table">
                        <tbody>
                            <tr>
                                <td>Header</td>
                                <td>Authorization</td>
                            </tr>
                            <tr>
                                <td>Token Type</td>
                                <td>Bearer</td>
                            </tr>
                            <tr>
                                <td>Url</td>
                                <td><?php echo e(url('/')); ?></td>
                            </tr>
                        </tbody>
                    </table>
                    <h5>Token</h5>
                    <span id="token"></span>

                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                </div>
            </div>
        </div>
    </div>

    <script>
        function populate_modal(agent, token) {
            agent_ele = document.getElementById('payment_agent');
            token_ele = document.getElementById('token');

            agent_ele.textContent = agent;
            token_ele.textContent = token;
        }
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.logged_in', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/portal.nzuritrust.com/public_html/Ebanqr-API/resources/views/payment_agent/index.blade.php ENDPATH**/ ?>