<?php $__env->startSection('title', 'Loan Application'); ?>

<?php $__env->startSection('heading', $user->name. ' / '. 'New Loan Application'. ' ['.  str_replace('_', ' ', $loan->loan_product_name) . ' - '. $loan->interval . ' ]'); ?>

<?php $__env->startSection('content'); ?>
    <?php echo $__env->make('partials._messages', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <form class="mt-3" action="<?php echo e(route('terms.post')); ?>" method="POST">
        <?php echo csrf_field(); ?>
        <input type="hidden" name="loan_id" value="<?php echo e($loan_id); ?>">
        <div class="row">
            <div class="col-2"></div>
            <div class="col-6">
                <div class="mb-3 row">
                    <label for="loan_principle" class="col-sm-3 col-form-label">Loan Principle</label>
                    <div class="col-sm-9">
                        <input name="loan_principle" id="loan_principle" type="number"  class="form-control" value="<?php echo e(old('loan_principle', $loan->loan_amount ?? $loan_product->minPrincipal)); ?>" min="<?php echo e($loan_product->minPrincipal); ?>" max="<?php echo e($loan_product->maxPrincipal); ?>" >
                        <span>(Min: <?php echo e($loan_product->minPrincipal); ?>, Max: <?php echo e($loan_product->maxPrincipal); ?>)</span>
                    </div>
                </div>
                <div class="mb-3 row">
                    <label for="loan_term" class="col-sm-3 col-form-label">Loan Period</label>
                    <div class="col-sm-9">
                        <input name="loan_term" id="loan_term" type="number" min="1" max="12" class="form-control" value="<?php echo e(old('loan_term', $loan->loan_term ?? '')); ?>" >
                    </div>
                </div>













                <div class="d-flex justify-content-end">
                    <a href="<?php echo e(route('loan_application.index')); ?>" class="btn btn-secondary">Cancel</a>&nbsp;
                    <button type="submit" class="btn btn-primary">Next</button>
                </div>

            </div>
            <div class="col"></div>
        </div>
    </form>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.logged_in', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/vhosts/portal.nzuritrust.com/httpdocs/Ebanqr-API/resources/views/loan_application/wizard/terms.blade.php ENDPATH**/ ?>