<?php $__env->startSection('title', 'Loans Administration'); ?>

<?php $__env->startSection('heading', 'Loans Administration'); ?>

<?php $__env->startSection('content'); ?>
    <?php echo $__env->make('partials._messages', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <div class="mt-5">
        <ul class="nav nav-tabs full-width-tabs" id="myTabs">
            <li class="nav-item">
                <a class="nav-link active" id="tab1" data-bs-toggle="tab" href="#content1">View Pending Loans</a>
            </li>
            <li class="nav-item">
                <a class="nav-link" id="tab2" data-bs-toggle="tab" href="#content2">View All Loans</a>
            </li>
            <!-- Add more tabs as needed -->
        </ul>

        <div class="tab-content mt-2">
            <div class="tab-pane fade show active" id="content1">
                <table class="table">
                    <thead>
                    <tr>
                        <th>Loan Amount</th>
                        <th>Loan Period</th>
                        <th>Loan Purpose</th>
                        <th>Loan Product</th>
                        <th>Security Offered</th>
                        <th>comments</th>
                        <th>Status</th>
                        <th>Actions</th>
                    </tr>
                    </thead>
                    <tbody>
                    <?php $__currentLoopData = $loans; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $loan): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr>
                            <td class="text-end"><?php echo e(number_format($loan->loan_amount, 2, '.', ',')); ?></td>
                            <td><?php echo e($loan->interval); ?></td>
                            <td><?php echo e(ucfirst(str_replace('_', ' ', $loan->loan_purpose))); ?></td>
                            <td><?php echo e(ucfirst(str_replace('_', ' ', $loan->loan_product))); ?></td>
                            <td><?php echo e(ucfirst($loan->security_offered)); ?></td>
                            <td>
                                <button type="button" class="btn btn-primary btn-sm" data-bs-toggle="modal" data-bs-target="#approvalRecordsModal<?php echo e($loan->id); ?>">
                                    View Comments
                                </button>
                            </td>
                            <td>
                                <span class="badge <?php if($loan->status == 'pending'): ?> bg-warning <?php elseif($loan->status == 'approved'): ?> bg-success <?php elseif($loan->status == 'rejected'): ?> bg-danger <?php endif; ?>"><?php echo e(ucfirst($loan->status)); ?></span>
                            </td>
                            <th>
                                <?php if($loan->status == 'pending'): ?>
                                    <button type="button" class="btn btn-sm btn-success" data-bs-toggle="modal" data-bs-target="#approvalModal<?php echo e($loan->id); ?>">
                                        Approve Loan
                                    </button>
                                <?php endif; ?>
                                <?php if($loan->status == 'pending'): ?>
                                    <button type="button" class="btn btn-sm btn-danger" data-bs-toggle="modal" data-bs-target="#rejectModal<?php echo e($loan->id); ?>">
                                        Reject Loan
                                    </button>

                                    <div class="modal fade" id="rejectModal<?php echo e($loan->id); ?>" tabindex="-1" aria-labelledby="rejectModalLabel<?php echo e($loan->id); ?>" aria-hidden="true">
                                        <div class="modal-dialog">
                                            <div class="modal-content">
                                                <div class="modal-header">
                                                    <h5 class="modal-title" id="rejectModalLabel<?php echo e($loan->id); ?>">Reject Loan</h5>
                                                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                                                </div>
                                                <div class="modal-body">
                                                    <form method="POST" action="<?php echo e(route('loan_application.reject', ['loan' => $loan->id])); ?>">
                                                        <?php echo csrf_field(); ?>
                                                        <?php echo method_field('PUT'); ?>
                                                        <div class="mb-3">
                                                            <label for="comment">Rejection Comment:</label>
                                                            <textarea name="comment" class="form-control" required></textarea>
                                                        </div>
                                                        <button type="submit" class="btn btn-danger">Reject Loan</button>
                                                    </form>
                                                </div>
                                            </div>
                                        </div>
                                    </div>

                                    <div class="modal fade" id="approvalModal<?php echo e($loan->id); ?>" tabindex="-1" aria-labelledby="approvalModalLabel<?php echo e($loan->id); ?>" aria-hidden="true">
                                        <div class="modal-dialog">
                                            <div class="modal-content">
                                                <div class="modal-header">
                                                    <h5 class="modal-title" id="approvalModalLabel<?php echo e($loan->id); ?>">Approve Loan</h5>
                                                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                                                </div>
                                                <div class="modal-body">
                                                    <form method="POST" action="<?php echo e(route('loan_application.approve', ['loan' => $loan->id])); ?>">
                                                        <?php echo csrf_field(); ?>
                                                        <?php echo method_field('PUT'); ?>
                                                        <div class="mb-3">
                                                            <label for="comment">Amount</label>
                                                            <input name="amount" class="form-control" type="number" value="<?php echo e($loan->loan_amount); ?>" max="<?php echo e($loan->loan_amount); ?>" required />
                                                        </div>
                                                        <div class="mb-3">
                                                            <label for="comment">Approval Comment:</label>
                                                            <textarea name="comment" class="form-control" required></textarea>
                                                        </div>
                                                        <button type="submit" class="btn btn-success">Approve Loan</button>
                                                    </form>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                <?php endif; ?>
                            </th>
                        </tr>
                        <div class="modal fade" id="approvalRecordsModal<?php echo e($loan->id); ?>" tabindex="-1" aria-labelledby="approvalRecordsModalLabel<?php echo e($loan->id); ?>" aria-hidden="true">
                            <div class="modal-dialog">
                                <div class="modal-content">
                                    <div class="modal-header">
                                        <h5 class="modal-title" id="approvalRecordsModalLabel<?php echo e($loan->id); ?>">Approval Records for Loan <?php echo e($loan->loan_amount); ?></h5>
                                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                                    </div>
                                    <div class="modal-body">
                                        <?php
                                            $approvalRecords = DB::table('approval_records')->where('loan_id', '=', $loan->id )->get();
                                        ?>
                                        <?php $__currentLoopData = $approvalRecords; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $approvalRecord): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <!-- Display each approval record details here -->

                                            <p>Approval Level: <?php echo e($approvalRecord->approval_level); ?></p>
                                            <p>Adjusted Amount: <?php echo e($approvalRecord->adjusted_amount); ?></p>
                                            <p>Comments: <?php echo e($approvalRecord->comments); ?></p>
                                            <!-- Add more details as needed -->
                                            <hr>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </div>
                                </div>
                            </div>
                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                </table>
            </div>
            <div class="tab-pane fade" id="content2">
                <table class="table">
                    <thead>
                    <tr>
                        <th>Loan Amount</th>
                        <th>Loan Period</th>
                        <th>Loan Purpose</th>
                        <th>Loan Product</th>
                        <th>Security Offered</th>
                        <th>comments</th>
                        <th>Status</th>
                    </tr>
                    </thead>
                    <tbody>
                    <?php $__currentLoopData = $allLoans; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $loan): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr>
                            <td class="text-end"><?php echo e(number_format($loan->loan_amount, 2, '.', ',')); ?></td>
                            <td><?php echo e($loan->interval); ?></td>
                            <td><?php echo e(ucfirst(str_replace('_', ' ', $loan->loan_purpose))); ?></td>
                            <td><?php echo e(ucfirst(str_replace('_', ' ', $loan->loan_product))); ?></td>
                            <td><?php echo e(ucfirst($loan->security_offered)); ?></td>
                            <td>
                                <button type="button" class="btn btn-primary btn-sm" data-bs-toggle="modal" data-bs-target="#approvalRecordsAllModal<?php echo e($loan->id); ?>">
                                    View Comments
                                </button>
                            </td>
                            <td>
                                <span class="badge <?php if($loan->status == 'pending'): ?> bg-warning <?php elseif($loan->status == 'approved'): ?> bg-success <?php elseif($loan->status == 'rejected'): ?> bg-danger <?php endif; ?>"><?php echo e(ucfirst($loan->status)); ?></span>
                            </td>
                        </tr>
                        <div class="modal fade" id="approvalRecordsAllModal<?php echo e($loan->id); ?>" tabindex="-1" aria-labelledby="approvalRecordsAllModalLabel<?php echo e($loan->id); ?>" aria-hidden="true">
                            <div class="modal-dialog">
                                <div class="modal-content">
                                    <div class="modal-header">
                                        <h5 class="modal-title" id="approvalRecordsAllModalLabel<?php echo e($loan->id); ?>">Approval Records for Loan <?php echo e(number_format($loan->loan_amount, 2, '.', ',')); ?> </h5>
                                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                                    </div>
                                    <div class="modal-body">
                                        <?php
                                            $approvalRecords = DB::table('approval_records')->where('loan_id', '=', $loan->id )->get();
                                        ?>
                                        <?php $__currentLoopData = $approvalRecords; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $record): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>


                                            <p>Approval Level: <?php echo e($record->approval_level); ?></p>
                                            <p>Adjusted Amount: <?php echo e($record->adjusted_amount); ?></p>
                                            <p>Comments: <?php echo e($record->comments); ?></p>

                                            <hr>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </div>
                                </div>
                            </div>
                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                </table>
            </div>
            <!-- Add more content panes as needed -->
        </div>
    </div>
<?php $__env->stopSection(); ?>

<style>
    /* Custom styles for full-width tabs */
    .full-width-tabs .nav-item {
        flex: 1;
        text-align: center;
    }
</style>


<?php echo $__env->make('layouts.logged_in', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/vhosts/nzuritrust.com/portal.nzuritrust.com/Ebanqr-API/resources/views/loan_application/loan_approval.blade.php ENDPATH**/ ?>