<?php $__env->startSection('title', 'Loan Application'); ?>

<?php $__env->startSection('heading', $user->name. ' / '. 'New Loan Application'. ' ['.  str_replace('_', ' ', $loan->loan_product_name) . ' - '. $loan->interval . ' ]'); ?>

<?php $__env->startSection('content'); ?>
    <?php echo $__env->make('partials._messages', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <div class="panel panel-default">
        <div class="panel-body">
            <!-- begin body -->

            <div class="text text-center">
                <span class="h3 text text-muted">LOAN APPLICATION PREVIEW</span>
            </div>

            <br>

            <div class="panel panel-default">
                <div class="panel-body">

                    <div class="page-header-custom">
                        <div class="row">
                            <div class="col-sm-11"><h4> 1.0 LOAN TERMS </h4></div>
                            <div class="col-sm-1 text-right">
                                <a class="btn btn-primary btn-sm" href="<?php echo e(route('terms.index', compact('loan_id'))); ?>" role="button"><span class="glyphicon glyphicon-edit" aria-hidden="true"></span> Edit</a>
                            </div>
                        </div>
                    </div>

                    <div class="table-responsive">
                        <table class="table table-striped table-bordered table-condensed">
                            <tbody>
                            <tr>
                                <td>LOAN PRINCIPLE: <?php echo e($loan->loan_amount); ?> </td>
                                <td>LOAN TERM: <?php echo e($loan->loan_term); ?></td>
                            </tr>
                            </tbody>
                        </table>
                    </div>

                    <div class="page-header-custom">
                        <div class="row">
                            <div class="col-sm-11"><h4> 2.0 LOAN SETTINGS </h4></div>
                            <div class="col-sm-1 text-right">
                                <a class="btn btn-primary btn-sm" href="<?php echo e(route('settings.index', compact('loan_id'))); ?>" role="button"><span class="glyphicon glyphicon-edit" aria-hidden="true"></span> Edit</a>
                            </div>
                        </div>
                    </div>

                    <div class="table-responsive">
                        <table class="table table-striped table-bordered table-condensed">
                            <tbody>
                            <tr>
                                <td>LOAN PURPOSE: <br> <?php echo e(ucwords(str_replace('_', ' ', $loan->loan_purpose ))); ?> </td>
                                <td>LOAN CLASSIFICATION: <br> <?php echo e(ucwords(str_replace('_', ' ',$loan->loan_classification ))); ?></td>
                                <td>LINKED ACCOUNT: <br> <?php echo e($loan->linked_account); ?></td>
                                <td>IS TOP-UP: <br> <?php echo e($loan->is_top_up); ?></td>
                                <td>FIRST REPAYMENT ON: <br> <?php echo e($loan->first_repayment_date); ?></td>
                            </tr>
                            </tbody>
                        </table>
                    </div>

                    <div class="page-header-custom">
                        <div class="row">
                            <div class="col-sm-11"><h4>3.0 LOAN GUARANTORS</h4></div>
                            <div class="col-sm-1 text-right">
                                <a class="btn btn-primary btn-sm" href="<?php echo e(route('guarantor.index', compact('loan_id'))); ?>" role="button"><span class="glyphicon glyphicon-edit" aria-hidden="true"></span> Edit</a>
                            </div>
                        </div>
                    </div>

                    <table class="table table-striped table-bordered table-condensed">
                        <thead>
                        <tr>
                            <th>Name</th>
                            <th>Relationship</th>
                            <th>Date of Birth</th>
                            <th>Address</th>
                            <th>Contact</th>
                        </tr>
                        </thead>
                        <tbody>
                        <?php $__currentLoopData = $loan_guarantors; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $loan_guarantor): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                                <td><?php echo e($loan_guarantor->first_name); ?></td>
                                <td><?php echo e($loan_guarantor->relationship); ?></td>
                                <td><?php echo e($loan_guarantor->date_of_birth); ?></td>
                                <td><?php echo e($loan_guarantor->address); ?></td>
                                <td><?php echo e($loan_guarantor->phone_number); ?></td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>
                    </table>

                    <div class="page-header-custom">
                        <div class="row">
                            <div class="col-sm-11"><h4>4.0 LOAN COLLATERAL</h4></div>
                            <div class="col-sm-1 text-right">
                                <a class="btn btn-primary btn-sm" href="<?php echo e(route('collateral.index', compact('loan_id'))); ?>" role="button"><span class="glyphicon glyphicon-edit" aria-hidden="true"></span> Edit</a>
                            </div>
                        </div>
                    </div>
                    <table class="table table-striped table-bordered table-condensed">
                        <thead>
                        <tr>
                            <th>Type</th>
                            <th>Value</th>
                            <th>Description</th>
                        </tr>
                        </thead>
                        <tbody>
                        <?php $__currentLoopData = $collateral; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $result): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                                <td><?php echo e($result->collateral_type); ?></td>
                                <td><?php echo e($result->value); ?></td>
                                <td><?php echo e($result->description); ?></td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>
                    </table>
                </div>
            </div>

            <!-- end of body -->
        </div></div>
    <div class="d-flex justify-content-end">
        <a href="<?php echo e(route('loan_application.index')); ?>" class="btn btn-primary">SAVE</a>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.logged_in', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/vhosts/portal.nzuritrust.com/httpdocs/Ebanqr-API/resources/views/loan_application/wizard/preview.blade.php ENDPATH**/ ?>