<?php echo csrf_field(); ?>
<div class="row">
    <div class="col-2"></div>

    <div class="col-6 ">

        <div class="mb-3 row">
            <label for="loan_amount" class="col-sm-3 col-form-label">Loan Amount applied for</label>
            <div class="col-sm-9">
                <input name="loan_amount" type="number" class="form-control" id="loan_amount">
            </div>
        </div>

        <div class="mb-3 row">
            <label for="loan_purpose" class="col-sm-3 col-form-label">Loan Purpose</label>
            <div class="col-sm-9">
                <select name="loan_purpose" id="loan_purpose" class="form-control" onchange="showOtherInput()">
                    <option value="working_capital_finance">Working Capital Finance</option>
                    <option value="project_finance">Project Finance</option>
                    <option value="school_fees_study_loan">School Fees/Study Loan</option>
                    <option value="home_loans">Home Loans (New Property Acquisition or Upgrade of Existing)</option>
                    <option value="asset_acquisition">Other Asset Acquisition (e.g., Motor Vehicle, Machinery, Equipment, etc.)</option>
                    <option value="agriculture">Agriculture</option>
                    <option value="other">Other purpose(Please specify)</option>
                </select>
            </div>
        </div>

        <div class="mb-3 row hidden" id="otherInput">
            <label for="other_loan_type" class="col-sm-3 col-form-label">Specify Other:</label>
            <div class="col-sm-9">
                <input type="text" name="other_loan_type" id="other_loan_type" class="form-control">
            </div>
        </div>

        <div class="mb-3 row">
            <label for="loan_product" class="col-sm-3 col-form-label" >Loan Product:</label>
            <div class="col-sm-9">
                <select name="loan_product" id="loan_product" class="form-control" onchange="updateLoanPeriodOptions()">
                    <option value="-">---</option>
                    <option value="emergency_day_loan">Emergency Day Loan</option>
                    <option value="express_loan">Express Loan</option>
                    <option value="business_loan">Business Loan</option>
                    <option value="group_loans">Group Loans</option>
                    <option value="salary_loans">Salary Loans</option>
                    <option value="personal_loans">Personal Loans</option>
                </select>
            </div>
        </div>

        <div class="mb-3 row">
            <label for="loan_period" class="col-sm-3 col-form-label">Loan Period</label>
            <div class="col-sm-9">
                <select class="form-control" name="interval" id="interval"></select>
            </div>
        </div>

        <div class="mb-3 row">
            <label for="security_offered" class="col-sm-3 col-form-label">Security Offered</label>
            <div class="col-sm-9">
                <input name="security_offered" type="text"  class="form-control" id="security_offered">
            </div>
        </div>

        <div class="d-flex justify-content-end">
            <a href="<?php echo e(route('loan_application.index')); ?>" class="btn btn-secondary">Cancel</a>&nbsp;
            <button type="submit" class="btn btn-primary"><?php echo e($button); ?></button>
        </div>

    </div>

    <div class="col"></div>
</div>

<style>
    .hidden {
        display: none;
    }
</style>

<script>
    function showOtherInput() {
        let selectedOption = document.getElementById('loan_purpose').value;
        let otherInputDiv = document.getElementById('otherInput');

        if (selectedOption === 'other') {
            otherInputDiv.classList.remove('hidden');
        } else {
            otherInputDiv.classList.add('hidden');
        }
    }

    function updateLoanPeriodOptions() {
        let loanProductSelect = document.getElementById('loan_product');
        let intervalSelect = document.getElementById('interval');

        // Clear existing options
        intervalSelect.innerHTML = '';

        // Define loan period options based on the selected loan product
        let loanPeriodOptions = {
            'emergency_day_loan': ['1 day'],
            'express_loan': ['1 week', '2 weeks', '4 weeks'],
            'business_loan': ['3 months', '4 months', '5 months','6 months', ' 7 months', '8 months', '9 months', '10 months', '11 months', '12 months'],
            'group_loans': ['16 weeks', '20 weeks', '50 weeks'],
            'salary_loans': ['3 months', '4 months', '5 months','6 months', ' 7 months', '8 months', '9 months', '10 months', '11 months', '12 months'],
            'personal_loans': ['3 months', '4 months', '5 months','6 months', ' 7 months', '8 months', '9 months', '10 months', '11 months', '12 months'],
        };

        // Get selected loan product
        let selectedLoanProduct = loanProductSelect.value;

        // Populate loan period options
        loanPeriodOptions[selectedLoanProduct].forEach(function (option) {
            let optionElement = document.createElement('option');
            optionElement.value = option;
            optionElement.text = option;
            intervalSelect.appendChild(optionElement);
        });
    }
</script>
<?php /**PATH /var/www/vhosts/nzuritrust.com/portal.nzuritrust.com/Ebanqr-API/resources/views/loan_application/_form.blade.php ENDPATH**/ ?>