@extends('layouts.logged_in')

@section('title', 'Users')

@section('heading', 'Users')

@section('content')
    @include('partials._messages')

    {{-- @can('administration', $user)
        <a class="btn btn-secondary" href="{{ route('user.create') }}">Add User</a>
    @endcan --}}
    @include('partials._search_box', ['route' => 'user.index'])

    <hr>
    <table class="table">
        <thead>
            <tr>
                <th>Account</th>
                <th>Name</th>
                <th>Email</th>
                <th>Gender</th>
                <th>Date of Birth</th>
                <th>Role</th>
                <th>Status</th>
                <th>Created</th>
                <th></th>
            </tr>
        </thead>
        <tbody>
            @foreach ($users as $k => $U)
                <tr>
                    <td>{{ $U->account }}</td>
                    <td>{{ $U->name }}</td>
                    <td>{{ $U->email }}</td>
                    <td>{{ $U->gender }}</td>
                    <td>{{ $U->date_of_birth }} @if ($U->date_of_birth)
                            ({{ $U->get_age($U->date_of_birth) }} Years)
                        @endif
                    </td>
                    <td><span class="{{ $U->text_class($U->role) }}"> {{ $U->role }} </span></td>
                    <td>
                        <span class="{{ $U->text_class($U->is_active) }}">
                            {{ $U->status($U->is_active) }}
                        </span>
                    </td>
                    <td>{{ $U->created_at }}</td>
                    <td class="text-center">
                        <a class="btn btn-primary" href="{{ route('user.edit', $U->id) }}">Edit</a>

                        {{-- <form method="POST" style="display:inline;" action="{{ route('user.delete', $U->id) }}">
                            @csrf
                            @method('DELETE')
                            <button type="submit" class="btn btn-danger"
                                onclick="confirm('Are you sure you want to delete this item?')">Delete</button>
                        </form> --}}

                    </td>
                </tr>
            @endforeach
        </tbody>
    </table>

    {{ $users->appends(request()->input())->links() }}
@endsection
