@csrf
<div class="row">
    <div class="col-2"></div>

    <div class="col-6 ">

        <div class="mb-3 row">
            <label for="account" class="col-sm-3 col-form-label">Account</label>
            <div class="col-sm-9">
                <input name="account" type="text" value="{{ old('account', $user_model->account) }}" readonly
                    class="form-control" id="account">
            </div>
        </div>

        <div class="mb-3 row">
            <label for="name" class="col-sm-3 col-form-label">Name</label>
            <div class="col-sm-9">
                <input name="name" type="text" value="{{ old('name', $user_model->name) }}" readonly
                    class="form-control" id="name">
            </div>
        </div>

        <div class="mb-3 row">
            <label for="date_of_birth" class="col-sm-3 col-form-label">Date of birth</label>
            <div class="col-sm-9">
                <input name="date_of_birth" type="text"
                    value="{{ old('date_of_birth', $user_model->date_of_birth) }}" readonly class="form-control"
                    id="date_of_birth">
            </div>
        </div>

        <div class="mb-3 row">
            <label for="gender" class="col-sm-3 col-form-label">Gender</label>
            <div class="col-sm-9">

                <select name="gender" class="form-control" id="gender">
                    <option value=""> Select Gender </option>
                    <option @if (old('gender', $user_model->gender) === 'M') selected @endif value="M"> Male </option>
                    <option @if (old('gender', $user_model->gender) === 'F') selected @endif value="F"> Female </option>
                </select>

            </div>
        </div>

        <div class="mb-3 row">
            <label for="email" class="col-sm-3 col-form-label">Email</label>
            <div class="col-sm-9">
                <input name="email" type="email" value="{{ old('email', $user_model->email) }}" readonly
                    class="form-control" id="email">
            </div>
        </div>

        <div class="mb-3 row">
            <label for="role" class="col-sm-3 col-form-label">Role</label>
            <div class="col-sm-9">
                <select name="role" class="form-control" id="role">
                    <option value=""> Select Role </option>

                    @foreach ($roles as $R)
                        @if ($R == 'PaymentAgent')
                            @continue
                        @endif

                        <option @if (old('role', $user_model->role) === $R) selected @endif value="{{ $R }}">
                            {{ $R }}
                        </option>
                    @endforeach
                </select>
            </div>
        </div>

        <div class="mb-3 row">
            <label for="is_active" class="col-sm-3 col-form-label">Status</label>
            <div class="col-sm-9">

                <select name="is_active" class="form-control" id="is_active">
                    <option value=""> Select Status </option>
                    <option @if (old('is_active', $user_model->is_active) == 1) selected @endif value="1"> Active </option>
                    <option @if (old('is_active', $user_model->is_active) == 0) selected @endif value="0"> Disabled </option>
                </select>

            </div>
        </div>

        <div class="d-flex justify-content-end">
            <a href="{{ route('user.index') }}" class="btn btn-secondary">Cancel</a>&nbsp;
            <button type="submit" class="btn btn-primary">{{ $button }}</button>
        </div>

    </div>

    <div class="col"></div>
</div>
