@csrf
<div class="row">
    <div class="col-2"></div>

    <div class="col-6 ">

        <div class="mb-3 row">
            <label for="name" class="col-sm-3 col-form-label">Name</label>
            <div class="col-sm-9">
                <input name="name" type="text" value="{{ old('name', $user_model->name) }}" class="form-control"
                    id="name">
            </div>
        </div>

        <div class="mb-3 row">
            <label for="email" class="col-sm-3 col-form-label">Email</label>
            <div class="col-sm-9">
                <input name="email" type="email" value="{{ old('email', $user_model->email) }}" class="form-control"
                    id="email">
            </div>
        </div>

        <div class="mb-3 row">
            <label for="environment" class="col-sm-3 col-form-label">Environment</label>
            <div class="col-sm-9">

                <select name="environment" class="form-control" id="environment">
                    <option value=""> Select Environment </option>
                    <option @if (old('environment', $user_model->environment) === 'TEST') selected @endif value="TEST"> Test </option>
                    <option @if (old('environment', $user_model->environment) === 'PRODUCTION') selected @endif value="PRODUCTION"> Production </option>
                </select>

            </div>
        </div>

        <div class="mb-3 row">
            <label for="api_token_status" class="col-sm-3 col-form-label">API Token Status</label>
            <div class="col-sm-9">

                <select name="api_token_status" class="form-control" id="api_token_status">
                    <option value=""> Select API Token Status </option>
                    <option @if (old('api_token_status', $user_model->api_token_status) == 1) selected @endif value="1"> Active </option>
                    <option @if (old('api_token_status', $user_model->api_token_status) == 0) selected @endif value="0"> Disabled </option>
                </select>

            </div>
        </div>

        <div class="d-flex justify-content-end">
            <a href="{{ route('payment_agent.index') }}" class="btn btn-secondary">Cancel</a>&nbsp;
            <button type="submit" class="btn btn-primary">{{ $button }}</button>
        </div>

    </div>

    <div class="col"></div>
</div>
