@extends('layouts.logged_in')

@section('title', 'Loan Application')

@section('heading', $user->name. ' / '. 'New Loan Application'. ' ['.  str_replace('_', ' ', $loan->loan_product_name) . ' - '. $loan->interval . ' ]')

@section('content')
    @include('partials._messages')
    <div class="panel panel-default">
        <div class="panel-body">
            <!-- begin body -->

            <div class="text text-center">
                <span class="h3 text text-muted">LOAN APPLICATION PREVIEW</span>
            </div>

            <br>

            <div class="panel panel-default">
                <div class="panel-body">

                    <div class="page-header-custom">
                        <div class="row">
                            <div class="col-sm-11"><h4> 1.0 LOAN TERMS </h4></div>
                            <div class="col-sm-1 text-right">
                                <a class="btn btn-primary btn-sm" href="{{ route('terms.index', compact('loan_id')) }}" role="button"><span class="glyphicon glyphicon-edit" aria-hidden="true"></span> Edit</a>
                            </div>
                        </div>
                    </div>

                    <div class="table-responsive">
                        <table class="table table-striped table-bordered table-condensed">
                            <tbody>
                            <tr>
                                <td>LOAN PRINCIPLE: {{$loan->loan_amount}} </td>
                                <td>LOAN TERM: {{$loan->loan_term}}</td>
                            </tr>
                            </tbody>
                        </table>
                    </div>

                    <div class="page-header-custom">
                        <div class="row">
                            <div class="col-sm-11"><h4> 2.0 LOAN SETTINGS </h4></div>
                            <div class="col-sm-1 text-right">
                                <a class="btn btn-primary btn-sm" href="{{ route('settings.index', compact('loan_id')) }}" role="button"><span class="glyphicon glyphicon-edit" aria-hidden="true"></span> Edit</a>
                            </div>
                        </div>
                    </div>

                    <div class="table-responsive">
                        <table class="table table-striped table-bordered table-condensed">
                            <tbody>
                            <tr>
                                <td>LOAN PURPOSE: <br> {{ ucwords(str_replace('_', ' ', $loan->loan_purpose ))}} </td>
                                <td>LOAN CLASSIFICATION: <br> {{ ucwords(str_replace('_', ' ',$loan->loan_classification )) }}</td>
                                <td>LINKED ACCOUNT: <br> {{$loan->linked_account}}</td>
                                <td>IS TOP-UP: <br> {{$loan->is_top_up}}</td>
                                <td>FIRST REPAYMENT ON: <br> {{$loan->first_repayment_date}}</td>
                            </tr>
                            </tbody>
                        </table>
                    </div>

                    <div class="page-header-custom">
                        <div class="row">
                            <div class="col-sm-11"><h4>3.0 LOAN GUARANTORS</h4></div>
                            <div class="col-sm-1 text-right">
                                <a class="btn btn-primary btn-sm" href="{{ route('guarantor.index', compact('loan_id')) }}" role="button"><span class="glyphicon glyphicon-edit" aria-hidden="true"></span> Edit</a>
                            </div>
                        </div>
                    </div>

                    <table class="table table-striped table-bordered table-condensed">
                        <thead>
                        <tr>
                            <th>Name</th>
                            <th>Relationship</th>
                            <th>Date of Birth</th>
                            <th>Address</th>
                            <th>Contact</th>
                        </tr>
                        </thead>
                        <tbody>
                        @foreach($loan_guarantors as $loan_guarantor)
                            <tr>
                                <td>{{$loan_guarantor->first_name}}</td>
                                <td>{{$loan_guarantor->relationship}}</td>
                                <td>{{$loan_guarantor->date_of_birth}}</td>
                                <td>{{$loan_guarantor->address}}</td>
                                <td>{{$loan_guarantor->phone_number}}</td>
                            </tr>
                        @endforeach
                        </tbody>
                    </table>

                    <div class="page-header-custom">
                        <div class="row">
                            <div class="col-sm-11"><h4>4.0 LOAN COLLATERAL</h4></div>
                            <div class="col-sm-1 text-right">
                                <a class="btn btn-primary btn-sm" href="{{ route('collateral.index', compact('loan_id')) }}" role="button"><span class="glyphicon glyphicon-edit" aria-hidden="true"></span> Edit</a>
                            </div>
                        </div>
                    </div>
                    <table class="table table-striped table-bordered table-condensed">
                        <thead>
                        <tr>
                            <th>Type</th>
                            <th>Value</th>
                            <th>Description</th>
                        </tr>
                        </thead>
                        <tbody>
                        @foreach($collateral as $result)
                            <tr>
                                <td>{{$result->collateral_type}}</td>
                                <td>{{$result->value}}</td>
                                <td>{{$result->description}}</td>
                            </tr>
                        @endforeach
                        </tbody>
                    </table>
                </div>
            </div>

            <!-- end of body -->
        </div></div>
    <div class="d-flex justify-content-end">
        <a href="{{ route('loan_application.index') }}" class="btn btn-primary">SAVE</a>
    </div>
@endsection
