@extends('layouts.logged_in')

@section('title', 'Loan Application')

@section('heading', $user->name. ' / '. 'New Loan Application'. ' ['.  str_replace('_', ' ', $loan->loan_product_name) . ' - '. $loan->interval . ' ]')

@section('content')
    @include('partials._messages')
    <style>
        .section {
            display: none;
        }
        #results {
            list-style-type: none;
            padding: 0;
        }
        #results li {
            padding: 5px;
            cursor: pointer;
        }
        #results li:hover {
            background-color: #f0f0f0;
        }
    </style>
    <button type="button" class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#collateral">Add Guarantor</button>
    <button type="button" class="btn btn-danger">Delete All</button><br><br>
    <h6><mark>External Customers</mark> </h6>
    <table class="table">
        <thead>
        <tr>
            <th>Name</th>
            <th>Date of Birth</th>
            <th>Address</th>
            <th>Contact</th>
            <th></th>
        </tr>
        </thead>
        <tbody>
        @if(isset($internal_guarantors))
            @foreach($internal_guarantors as $loan_guarantor)
                <tr>
                    <td>{{$loan_guarantor->first_name}} {{$loan_guarantor->last_name}}</td>
                    <td>{{$loan_guarantor->date_of_birth}}</td>
                    <td>{{$loan_guarantor->address}}</td>
                    <td>{{$loan_guarantor->phone_number}}</td>
                    <td>
                        <button class="btn btn-primary">Edit</button>
                        <button class="btn btn-danger">Delete</button>
                    </td>
                </tr>
            @endforeach
        @endif
        </tbody>
    </table>
    <h6> <mark>Existing Customers</mark></h6>
    <table class="table">
        <thead>
        <tr>
            <th>Name</th>
            <th>Action</th>
        </tr>
        </thead>
        <tbody>
        @if(isset($external_guarantors))
            @foreach($external_guarantors as $loan_guarantor)
                <tr>
                    <td>{{$loan_guarantor->displayName}}</td>
                    <td>
                        <button class="btn btn-danger">Delete</button>
                    </td>
                </tr>
            @endforeach
        @endif
        </tbody>
    </table>
    <div class="d-flex justify-content-end">
        <a href="{{ route('collateral.index', compact('loan_id')) }}" class="btn btn-secondary">Previous</a>&nbsp;
        <a href="{{ route('repayment_schedule.index', compact('loan_id')) }}" class="btn btn-primary">Next</a>
    </div>

@endsection

<div class="modal fade" id="collateral" tabindex="-1" aria-labelledby="guarantorLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="guarantorLabel">Add Loan Guarantor</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <form method="POST" action="{{ route('guarantor.post') }}">
                <div class="modal-body">
                    @csrf
                    <input type="hidden" name="loan_id" value="{{ $loan_id }}">
                    <div class="row">
                        <div class="col-2"></div>
                        <div class="col-8">
                            <div class="mb-3 row">
                                <label for="top_up" class="col-sm-3 col-form-label">Existing Client?</label>
                                <div class="col-sm-9">
                                    <div class="form-check form-check-inline">
                                        <input class="form-check-input" type="radio" name="clientType" id="inlineRadio1" value="YES">
                                        <label class="form-check-label" for="inlineRadio1">YES</label>
                                    </div>
                                    <div class="form-check form-check-inline">
                                        <input class="form-check-input" type="radio" name="clientType" id="inlineRadio2" value="NO">
                                        <label class="form-check-label" for="inlineRadio2">NO</label>
                                    </div>

                                </div>
                            </div>
                            <div class="section" id="NO">
                                <div class="mb-3 row">
                                    <label for="guarantor_relationship" class="col-sm-3 col-form-label">Relationship</label>
                                    <div class="col-sm-9">
                                        <select name="guarantor_relationship" id="guarantor_relationship" class="form-control">
                                            @if(isset($data))
                                                @foreach($data->allowedClientRelationshipTypes as $result)
                                                    <option value="{{$result->id}}">{{$result->name}}</option>
                                                @endforeach
                                            @endif
                                        </select>
                                    </div>
                                </div>
                                <div class="mb-3 row">
                                    <label for="guarantor_first_name" class="col-sm-3 col-form-label">First Name</label>
                                    <div class="col-sm-9">
                                        <input name="guarantor_first_name" id="guarantor_first_name" type="text" class="form-control">
                                    </div>
                                </div>
                                <div class="mb-3 row">
                                    <label for="guarantor_last_name" class="col-sm-3 col-form-label">Last Name</label>
                                    <div class="col-sm-9">
                                        <input name="guarantor_last_name" id="guarantor_last_name" type="text" class="form-control">
                                    </div>
                                </div>
                                <div class="mb-3 row">
                                    <label for="guarantor_dob" class="col-sm-3 col-form-label">Date of Birth</label>
                                    <div class="col-sm-9">
                                        <input name="guarantor_dob" id="guarantor_dob" type="date" class="form-control">
                                    </div>
                                </div>
                                <div class="mb-3 row">
                                    <label for="guarantor_address" class="col-sm-3 col-form-label">Address</label>
                                    <div class="col-sm-9">
                                        <textarea name="guarantor_address" id="guarantor_address" type="date" class="form-control" co></textarea>
                                    </div>
                                </div>
                                <div class="mb-3 row">
                                    <label for="guarantor_city" class="col-sm-3 col-form-label">City</label>
                                    <div class="col-sm-9">
                                        <input name="guarantor_city" id="guarantor_city" type="text" class="form-control">
                                    </div>
                                </div>
                                <div class="mb-3 row">
                                <label for="guarantor_tel" class="col-sm-3 col-form-label">Mobile Phone Number</label>
                                <div class="col-sm-9">
                                    <input name="guarantor_tel" id="guarantor_tel" type="tel" class="form-control">
                                </div>
                            </div>
                            </div>
                        </div>
                        <div class="col"></div>
                    </div>
                    <div class="row section" id="YES">
                        <div class="col-2"></div>
                        <div class="col-8">
                            <div class="mb-3 row">
                                <label for="guarantor_type" class="col-sm-3 col-form-label">Designation</label>
                                <div class="col-sm-9">
                                    <select name="guarantor_type" id="guarantor_type" class="form-control">
                                        @if(isset($data))
                                            @foreach($data->guarantorTypeOptions as $result)
                                                <option value="{{$result->id}}">{{$result->value}}</option>
                                            @endforeach
                                        @endif
                                    </select>
                                </div>
                            </div>
                            <div class="mb-3 row">
                                <label for="guarantor_relationship_existing" class="col-sm-3 col-form-label">Relationship</label>
                                <div class="col-sm-9">
                                    <select name="guarantor_relationship_existing" id="guarantor_relationship_existing" class="form-control">
                                        @if(isset($data))
                                            @foreach($data->allowedClientRelationshipTypes as $result)
                                                <option value="{{$result->id}}">{{$result->name}}</option>
                                            @endforeach
                                        @endif
                                    </select>
                                </div>
                            </div>
                            <div class="mb-3 row">
                                <label for="guarantor_details" class="col-sm-3 col-form-label">Account Number/<br>Name</label>
                                <div class="col-sm-9">
                                    <input name="guarantor_details" id="guarantor_details" type="text" class="form-control" placeholder="start typing ....">
                                    <input name="guarantor_client_id" id="guarantor_client_id" type="hidden" >
                                    <ul id="results"></ul>
                                </div>
                            </div>
                        </div>
                        <div class="col"></div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                    <button type="submit" class="btn btn-primary">Submit</button>
                </div>
            </form>
        </div>
    </div>
</div>
<script>
    document.addEventListener('DOMContentLoaded', function () {
        const radioButtons = document.querySelectorAll('input[name="clientType"]');
        radioButtons.forEach(radio => {
            radio.addEventListener('change', function () {
                // Hide all sections
                document.querySelectorAll('.section').forEach(section => {
                    section.style.display = 'none';
                });
                // Show the selected section
                const selectedSection = document.getElementById(this.value);
                if (selectedSection) {
                    selectedSection.style.display = 'block';
                }
            });
        });
    });
    //
    let debounceTimer;
    const searchInput = document.getElementById('guarantor_details');
    const hiddenInput = document.getElementById('guarantor_client_id');
    const resultList = document.getElementById('results');
    const submitButton = document.getElementById('submit-button');
    searchInput.addEventListener('input', function () {
        clearTimeout(debounceTimer);
        debounceTimer = setTimeout(() => {
            if(this.value.trim() === '') {
                resultList.innerHTML = '';
                submitButton.disabled = true;
            } else {
                performSearch(this.value);
            }
        }, 500)
    } );

    function performSearch(query) {
        axios.get(`/search_customer/${query}`)
            .then(response => {
                displayResults(response.data)
            })
            .catch(error => {
                console.log('Error fetching search results:', error);
            })
    }

    function displayResults(results) {
        resultList.innerHTML = '';
        const clients = results.filter(item => item.entityType === "CLIENT")
        clients.forEach(client => {
            const li = document.createElement('li')
            li.textContent = client.entityName + '(' + client.entityAccountNo + ')';
            li.addEventListener('click', () => selectResult(client));
            resultList.appendChild(li);
        })
    }

    function selectResult(result) {
        searchInput.value = result.entityName;
        hiddenInput.value = result.entityId
        resultList.innerHTML = ''
        submitButton.disabled = false
    }

    window.onload = function() {
        if(searchInput.value.trim() === '') {
            submitButton.disabled = true;
        }
    }
</script>
