@extends('layouts.logged_in')

@section('title', 'Loan Application')

@section('heading', 'Loan Application')

@section('content')
    @include('partials._messages')
    @include('loan_application.dropdowns.products', ['data' => $data])

    <hr>
    <table class="table">
        <thead>
        <tr>
            <th>Loan Amount Applied </th>
            <th>Loan Amount Approved</th>
            <th>Loan Period</th>
            <th>Loan Purpose</th>
            <th>Loan Product</th>
            <th>Status</th>
            <th></th>
        </tr>
        </thead>
        <tbody>
            @foreach($loans as $loan)
                <tr>
                    <td class="text-end">{{number_format($loan->loan_amount, 2, '.', ',')}}</td>
                    <td class="text-end">
                        @php
                            $approved_amount = null;
                            $loan_single = DB::table('loans')->where('id', $loan->id)->first();
                            $get_amount_approved = DB::table('approval_records')->where('loan_id' , $loan->id)->where('approval_level', $loan_single -> max_approval_level)->first();
                            if($get_amount_approved)
                            {
                                $approved_amount = $get_amount_approved->adjusted_amount;
                            }
                        @endphp
                        @if(!is_null($approved_amount))
                        {{ number_format( $approved_amount,2, '.', ',')}}
                        @endif
                    </td>
                    <td>{{$loan->interval}}</td>
                    <td>{{ucfirst(str_replace('_', ' ', $loan->loan_purpose))}}</td>
                    <td>{{ucfirst(str_replace('_', ' ', $loan->loan_product_name))}}</td>
                    <td>
                        <span class="badge @if ($loan->status == 'Approved') bg-success @elseif ($loan->status == 'Rejected') bg-danger @else bg-warning  @endif">{{ ucfirst($loan->status) }}</span>
                    </td>
                    <td>
{{--                        @if ($loan->status !== 'Approved')--}}
                        <a class="btn btn-primary btn-sm" href="{{ route('terms.index', $loan->id) }}" role="button"><span class="glyphicon glyphicon-edit" aria-hidden="true"></span> Edit</a>
                        <a class="btn btn-danger btn-sm" href="" role="button"><span class="glyphicon glyphicon-edit" aria-hidden="true"></span> Delete</a>
{{--                        @endif--}}
                    </td>
                </tr>
            @endforeach
        </tbody>
    </table>

@endsection
