@extends('layouts.logged_in')

@section('title', 'Add Loan Charge')

@section('heading', 'Add Loan Charge')

@section('content')
    @include('partials._messages')

    <form action="{{ route('loan_application.loan_charges_store') }}" method="POST">
        @csrf
        <div class="row">
            <div class="col-2"></div>

            <div class="col-6 ">

                <div class="mb-3 row">
                    <label for="loan_product" class="col-sm-3 col-form-label">Loan Products</label>
                    <div class="col-sm-9">
                        <select name="loan_product" id="loan_product" class="form-control">
                            @foreach($data as $result)
                                <option value="{{$result->id}}">{{$result->name}}</option>
                            @endforeach
                        </select>
                    </div>
                </div>

                <div class="mb-3 row">
                    <label for="loan_charge" class="col-sm-3 col-form-label">Loan Charges</label>
                    <div class="col-sm-9">
                        <select name="loan_charge" id="loan_charge" class="form-control">
                            @foreach($products_template->chargeOptions as $data)
                                <option value="{{$data->id}}">{{$data->name}}</option>
                            @endforeach
                        </select>
                    </div>
                </div>


                <div class="d-flex justify-content-end">
                    <a href="{{ route('loan_application.loan_charges_admin') }}" class="btn btn-secondary">Cancel</a>&nbsp;
                    <button type="submit" class="btn btn-primary">Save</button>
                </div>

            </div>

            <div class="col"></div>
        </div>
    </form>
@endsection
