@extends('layouts.logged_out')

@section('content')
    <div class="text-center">
        <img src="{{ asset('img/logo/nzurilogo.png') }}" class="img-thumbnail rounded" alt="Nzuri logo"/>
    </div>
    <br>
    <div class="card">

        <div class="card-body">
            <div class="m-sm-4">
                @if (session('status'))
                    <div class="alert alert-danger">
                        {{ session('status') }}
                    </div>
                @endif
                @if (session('otp_message_error'))
                    <div class="alert alert-danger">
                        {{ session('otp_message_error') }}
                    </div>
                @endif

                @if (session('otp_message'))
                    <div class="alert alert-success">
                        {{ session('otp_message') }}
                    </div>
                @endif
                @if(session('otp_verified') !== 'SUCCESS')
                        <div class="d-flex justify-content-center">
                            <h5 class="card-title">Confirm that the information below is yours.</h5>
                        </div>
                        <hr>
                        <table class="table">
                            <tr>
                                <th>Name :</th>
                                <td>{{ $EbankingActivationRequest->name }}</td>
                            </tr>
                            <tr>
                                <th>Account :</th>
                                <td>{{ $EbankingActivationRequest->account }}</td>
                            </tr>
                            <tr>
                                <th>Phone number:</th>
                                <td>
                                    {{ 'xxx-xxx-' . substr($EbankingActivationRequest->phone_number, -3) }}
                                    <a href="{{ route('send_otp', ['EbankingActivationRequest' => $EbankingActivationRequest->id]) }}"
                                       class="btn btn-lg btn-primary ms-6">SEND OTP</a>
                                </td>
                            </tr>
                        </table>

                        <div class="text-danger">If the information above is not yours, click the cancel button below</div>
                        <div class="text-center mt-3">
                            <a href="{{ route('account_number') }}" class="btn btn-lg btn-secondary">Cancel</a>
                        </div>
                        <hr>
                @endif

                @if(session('otp_verified') === 'SUCCESS')
                    <div class="d-flex justify-content-center">
                        <h5 class="card-title">Fill in the missing information to activate your account</h5>
                    </div>
                    <hr>
                    <form method="POST" action="{{ route('create_account') }}" class="row g-3">
                        @csrf
                        <input name="id" value="{{ $EbankingActivationRequest->id }}" type="hidden"/>
                        <div class="col-md-2">
                            <label for="title" class="form-label">Title</label>
                            <input type="text" class="form-control @error('title') is-invalid @enderror" id="title"
                                   name="title" value="{{old('title')}}" placeholder="Title">
                            @error('title')
                            <span class="invalid-feedback" role="alert">
                                <strong>{{ $message }}</strong>
                            </span>
                            @enderror
                        </div>
                        <div class="col-md-10">
                            <label for="name" class="form-label">Name</label>
                            <input type="text" class="form-control" id="name"
                                   name="name" value="{{ $EbankingActivationRequest->name }}" placeholder="Name"
                                   required readonly>
                        </div>

                        <div class="col-md-2">
                            <label class="form-label">Gender</label>
                            <div class="form-check form-check-inline">
                                <label for="male" class="form-check-label">M</label>
                                <input class="form-check-input @error('gender') is-invalid @enderror" type="radio"
                                       name="gender" id="male"
                                       value="M"
                                       {{ $EbankingActivationRequest->gender == 'M' ? 'checked' : '' }} {{isset($EbankingActivationRequest->gender) ? 'disabled' : ''}}>
                            </div>
                            <div class="form-check form-check-inline">
                                <label for="female" class="form-check-label">F</label>
                                <input class="form-check-input @error('gender') is-invalid @enderror" type="radio"
                                       name="gender" id="female"
                                       value="F"
                                       {{ $EbankingActivationRequest->gender == 'F' ? 'checked' : '' }} {{isset($EbankingActivationRequest->gender) ? 'disabled' : ''}}>
                            </div>
                            @if(isset($EbankingActivationRequest->gender))
                                <input name="gender" value="{{ $EbankingActivationRequest->gender }}" type="hidden"/>
                            @endif
                            @error('gender')
                            <span class="invalid-feedback" role="alert">
                                <strong>{{ $message }}</strong>
                            </span>
                            @enderror
                        </div>
                        <div class="col-md-4">
                            <label class="form-label" for="dob">Date of Birth</label>
                            <input type="date" class="form-control @error('date_of_birth') is-invalid @enderror"
                                   id="dob" name="date_of_birth" value="{{$EbankingActivationRequest->date_of_birth}}"
                                   placeholder="date of birth" required {{isset($EbankingActivationRequest->date_of_birth) ? 'readonly' : ''}}>
                            @error('date_of_birth')
                            <span class="invalid-feedback" role="alert">
                                <strong>{{ $message }}</strong>
                            </span>
                            @enderror
                        </div>
                        <div class="col-md-6">
                            <label class="form-label" for="nin">National ID No.:</label>
                            <input type="text" class="form-control @error('national_id_number') is-invalid @enderror"
                                   id="nin" name="national_id_number"
                                   value="{{$EbankingActivationRequest->national_id_number}}"
                                   placeholder="National ID No."
                                   required {{ isset($EbankingActivationRequest->national_id_number) ? 'readonly' : '' }}>
                            @error('national_id_number')
                            <span class="invalid-feedback" role="alert">
                                <strong>{{ $message }}</strong>
                            </span>
                            @enderror
                        </div>
                        <div class="col-md-12">
                            <label class="form-label" for="phone">Telephone No.:</label>
                            <input type="tel" class="form-control @error('phone') is-invalid @enderror" id="phone"
                                   name="phone" value="{{ $EbankingActivationRequest->phone_number }}"
                                   placeholder="Telephone No.:" required {{isset($EbankingActivationRequest->phone_number) ? 'readonly' : ''}}>
                            @error('phone')
                            <span class="invalid-feedback" role="alert">
                                <strong>{{ $message }}</strong>
                            </span>
                            @enderror
                        </div>
                        <div class="col-md-6">
                            <label class="form-label" for="work_address">Work Address</label>
                            <input type="text" class="form-control @error('work_address') is-invalid @enderror"
                                   id="work_address" name="work_address" value="{{old('work_address')}}"
                                   placeholder="Work Address">
                            @error('work_address')
                            <span class="invalid-feedback" role="alert">
                                <strong>{{ $message }}</strong>
                            </span>
                            @enderror
                        </div>
                        <div class="col-md-6">
                            <label class="form-label" for="residential_address">Residential Address</label>
                            <input type="text" class="form-control @error('residential_address') is-invalid @enderror"
                                   id="residential_address" name="residential_address"
                                   value="{{old('residential_address')}}" placeholder="Residential Address">
                            @error('residential_address')
                            <span class="invalid-feedback" role="alert">
                                <strong>{{ $message }}</strong>
                            </span>
                            @enderror
                        </div>
                        <label class="form-label">Marital Status</label>
                        <div class="col-md-2">
                            <div class="form-check form-check-inline">
                                <label class="form-check-label" for="single">Single</label>
                                <input class="form-check-input @error('marital_status') is-invalid @enderror"
                                       type="radio" id="single" name="marital_status"
                                       {{ old('marital_status') == 'single' ? 'checked' : '' }}
                                       value="single">
                            </div>
                        </div>
                        <div class="col-md-2">
                            <div class="form-check form-check-inline">
                                <label class="form-check-label" for="married">Married</label>
                                <input class="form-check-input @error('marital_status') is-invalid @enderror"
                                       type="radio" id="married" name="marital_status"
                                       {{ old('marital_status') == 'married' ? 'checked' : '' }}
                                       value="married">
                            </div>
                        </div>
                        <div class="col-md-2">
                            <div class="form-check form-check-inline">
                                <label class="form-check-label" for="widow">Widow</label>
                                <input class="form-check-input @error('marital_status') is-invalid @enderror"
                                       type="radio" id="widow" name="marital_status"
                                       {{ old('marital_status') == 'widow' ? 'checked' : '' }}
                                       value="widow">
                            </div>
                        </div>
                        <div class="col-md-2">
                            <div class="form-check form-check-inline">
                                <label class="form-check-label" for="widower">Widower</label>
                                <input class="form-check-input @error('marital_status') is-invalid @enderror"
                                       type="radio" id="widower" name="marital_status"
                                       {{ old('marital_status') == 'widower' ? 'checked' : '' }}
                                       value="widower">
                            </div>
                        </div>
                        <div class="col-md-2">
                            <div class="form-check form-check-inline">
                                <label class="form-check-label" for="separated">Separated</label>
                                <input class="form-check-input @error('marital_status') is-invalid @enderror"
                                       type="radio" id="separated" name="marital_status"
                                       {{ old('separated') == 'widower' ? 'checked' : '' }}
                                       value="separated">
                            </div>
                        </div>
                        @error('marital_status')
                        <span class="invalid-feedback" role="alert">
                                <strong>{{ $message }}</strong>
                            </span>
                        @enderror
                        <div class="col-md-6">
                            <label class="form-label" for="spouse_name">Spouse Name</label>
                            <input type="text" class="form-control @error('spouse_name') is-invalid @enderror"
                                   id="spouse_name" name="spouse_name" value="{{old('spouse_name')}}"
                                   placeholder="Spouse Name">
                            @error('spouse_name')
                            <span class="invalid-feedback" role="alert">
                                <strong>{{ $message }}</strong>
                            </span>
                            @enderror
                        </div>
                        <div class="col-md-6">
                            <label class="form-label" for="spouse_phone">Spouse Telephone No.:</label>
                            <input type="tel" class="form-control @error('spouse_phone') is-invalid @enderror"
                                   id="spouse_phone" name="spouse_phone" value="{{old('spouse_phone')}}"
                                   placeholder="Spouse phone">
                            @error('spouse_phone')
                            <span class="invalid-feedback" role="alert">
                                <strong>{{ $message }}</strong>
                            </span>
                            @enderror
                        </div>
                        <div class="col-md-6">
                            <label class="form-label" for="nok_name">Next of Kin Name</label>
                            <input type="text" class="form-control @error('spouse_name') is-invalid @enderror"
                                   id="nok_name" name="nok_name" value="{{old('nok_name')}}"
                                   placeholder="Next of Kin Name">
                            @error('nok_name')
                            <span class="invalid-feedback" role="alert">
                                <strong>{{ $message }}</strong>
                            </span>
                            @enderror
                        </div>
                        <div class="col-md-6">
                            <label class="form-label" for="nok_phone">Next of Kin Telephone No.:</label>
                            <input type="tel" class="form-control @error('nok_phone') is-invalid @enderror"
                                   id="nok_phone" name="nok_phone" value="{{old('spouse_phone')}}"
                                   placeholder="Next of Kin phone">
                            @error('nok_phone')
                            <span class="invalid-feedback" role="alert">
                                <strong>{{ $message }}</strong>
                            </span>
                            @enderror
                        </div>
                        <div class="col-md-6">
                            <label class="form-label" for="occupation">Occupation</label>
                            <input type="text" class="form-control @error('occupation') is-invalid @enderror"
                                   id="occupation" name="occupation" value="{{old('occupation')}}"
                                   placeholder="Occupation">
                            @error('occupation')
                            <span class="invalid-feedback" role="alert">
                                <strong>{{ $message }}</strong>
                            </span>
                            @enderror
                        </div>
                        <div class="col-md-6">
                            <label class="form-label" for="source_of_income">Source of Income</label>
                            <input type="text" class="form-control @error('source_of_income') is-invalid @enderror"
                                   id="source_of_income" name="source_of_income" value="{{old('source_of_income')}}"
                                   placeholder="Source of Income">
                            @error('source_of_income')
                            <span class="invalid-feedback" role="alert">
                                <strong>{{ $message }}</strong>
                            </span>
                            @enderror
                        </div>
                        <div class="mb-3">
                            <label class="form-label">Email</label>

                            <input id="email" type="email"
                                   class="form-control form-control-lg @error('email') is-invalid @enderror"
                                   name="email"
                                   value="{{ old('email') }}" placeholder="Enter your email" required
                                   autocomplete="email">

                            @error('email')
                            <span class="invalid-feedback" role="alert">
                                <strong>{{ $message }}</strong>
                            </span>
                            @enderror
                        </div>
                        <div class="mb-3">

                            <div class="mb-3">
                                <label class="form-label">Password</label>

                                <input id="password" type="password"
                                       class="form-control form-control-lg @error('password') is-invalid @enderror"
                                       name="password"
                                       required placeholder="Enter password" autocomplete="new-password">

                                @error('password')
                                <span class="invalid-feedback" role="alert">
                                <strong>{{ $message }}</strong>
                            </span>
                                @enderror
                            </div>

                            <div class="mb-3">
                                <label class="form-label">Confirm Password</label>

                                <input id="password-confirm" type="password"
                                       class="form-control form-control-lg @error('password') is-invalid @enderror"
                                       name="password_confirmation" required placeholder="Enter confirm password"
                                       autocomplete="new-password">

                                @error('password_confirmation')
                                <span class="invalid-feedback" role="alert">
                                <strong>{{ $message }}</strong>
                            </span>
                                @enderror
                            </div>

                            <div class="text-center mt-3">
                                <button type="submit" class="btn btn-lg btn-primary">Activate Account</button>
                            </div>
                    </form>
                @else
                    <form method="POST" action="{{route('verify_otp')}}">
                        @csrf
                        <div class="mb-3">
                            <label class="form-label">Enter One Time Password</label>
                            <input name="id" value="{{ $EbankingActivationRequest->id }}" type="hidden"/>
                            <input
                                id="otp"
                                type="password"
                                class="form-control form-control-lg @error('otp') is-invalid @enderror"
                                name="otp"
                                placeholder="Enter your one time password" required
                            >
                            @error('otp')
                            <span class="invalid-feedback" role="alert">
                                <strong>{{ $message }}</strong>
                            </span>
                            @enderror
                        </div>
                        <div class="text-center mt-3">
                            <button type="submit" class="btn btn-lg btn-primary">Verify</button>
                        </div>
                    </form>
                @endif
            </div>
        </div>
    </div>
@endsection
