@extends('layouts.logged_out')

@section('content')
    <div class="text-center">
        <img src="{{ asset('img/logo/nzurilogo.png') }}" class="img-thumbnail rounded" alt="Nzuri logo" />
    </div>
    <br>
    <div class="card">

        <div class="card-body">
            <div class="m-sm-4">
                @if (session('status'))
                    <div class="alert alert-success">
                        {{ session('status') }}
                    </div>
                @endif
                <div class="d-flex justify-content-center">
                    <h5 class="card-title">SIGN IN</h5>
                </div>
                <form method="POST" action="{{ route('login') }}">
                    @csrf
                    <div class="mb-3">
                        <label class="form-label">Email or Account Number</label>
                        <input class="form-control form-control-lg @error('login') is-invalid @enderror"
                            value="{{ old('login') }}" type="text" name="login" placeholder="Enter your login" />
                        @error('login')
                            <div class="invalid-feedback"> {{ $message }}</div>
                        @enderror
                    </div>
                    
                    <div class="mb-3">
                        <label class="form-label">Password</label>
                        <input class="form-control form-control-lg @error('password') is-invalid @enderror" type="password"
                            name="password" placeholder="Enter your password" />
                        @error('password')
                            <span class="invalid-feedback" role="alert">
                                <strong>{{ $message }}</strong>
                            </span>
                        @enderror
                        <small>
                            <a href="{{ route('password.request') }}">Forgot password?</a>
                        </small>
                        <br>
                        <small>
                            <a href="{{ route('account_number') }}">Activate ebanking</a>
                        </small>
                    </div>
                    <div>
                        <label class="form-check">
                            <input class="form-check-input" type="checkbox" value="remember-me" name="remember-me" >
                            <span class="form-check-label">
                                Remember me next time
                            </span>
                        </label>
                    </div>

                    <!-- CAPTCHA Section -->
                    <div class="mb-3">
                        <label class="form-label">Enter the code</label>
                        <div class="form-control form-control-lg">{{ $captcha }}</div>
                        <input type="text" name="captcha" class="form-control form-control-lg @error('captcha') is-invalid @enderror" placeholder="Enter the CAPTCHA code" />
                        @error('captcha')
                            <span class="invalid-feedback" role="alert">
                                <strong>{{ $message }}</strong>
                            </span>
                        @enderror
                    </div>

                    <div class="text-center mt-3">
                        <button type="submit" class="btn btn-lg btn-primary">Sign in</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
@endsection
