<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AddColumnsToLoansTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('loans', function (Blueprint $table) {
            $table->integer('loan_term')->nullable()->after('interval');
            $table->integer('number_of_repayments')->nullable()->after('loan_term');
            $table->integer('repayment_frequency')->nullable()->after('number_of_repayments');
            $table->string('loan_classification')->nullable()->after('repayment_frequency');
            $table->string('linked_account')->nullable()->after('loan_classification');
            $table->tinyInteger('standing_instruction')->nullable()->after('linked_account');
            $table->tinyInteger('is_top_up')->nullable()->after('standing_instruction');
            $table->date('first_repayment_date')->nullable()->after('is_top_up');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('loans', function (Blueprint $table) {
            $table->dropColumn('loan_term');
            $table->dropColumn('number_of_repayments');
            $table->dropColumn('repayment_frequency');
            $table->dropColumn('loan_classification');
            $table->dropColumn('linked_account');
            $table->dropColumn('standing_instruction');
            $table->dropColumn('is_top_up');
            $table->dropColumn('first_repayment_date');
        });
    }
}
