<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AddOneTimePasswordToEbankingActivationRequestsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('ebanking_activation_requests', function (Blueprint $table) {
            $table->string('otp')->after('phone_number')->nullable()->default(null);
            $table->timestamp('otp_expiry_time')->after('otp')->nullable()->default(null);
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('ebanking_activation_requests', function (Blueprint $table) {
            //
            $table->dropColumn('otp');
            $table->dropColumn('otp_expiry_time');
        });
    }
}
