<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AddColumnsToUsersTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('users', function (Blueprint $table) {
            
            $table->string('phone')->after('email')->nullable()->default(null);
            $table->string('work_address')->after('phone')->nullable()->default(null);
            $table->string('residential_address')->after('work_address')->nullable()->default(null);
            $table->string('marital_status')->after('residential_address')->nullable()->default(null);
            $table->string('spouse_name')->after('marital_status')->nullable()->default(null);
            $table->string('spouse_phone')->after('spouse_name')->nullable()->default(null);
            $table->string('nok_name')->after('spouse_phone')->nullable()->default(null);
            $table->string('nok_phone')->after('nok_name')->nullable()->default(null);
            $table->string('source_of_income')->after('nok_phone')->nullable()->default(null);
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('users', function (Blueprint $table) {
            $table->dropColumn([
                'phone',
                'work_address',
                'residential_address',
                'marital_status',
                'spouse_name',
                'spouse_phone',
                'nok_name',
                'nok_phone',
                'source_of_income',
            ]);
        });
    }
}
