<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateAPITransactionsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('api_transactions', function (Blueprint $table) {
            $table->id();
            $table->string('payment_agent')->nullable();
            $table->string('accountNumber')->nullable();
            $table->string('name')->nullable();
            $table->string('phoneNumber')->nullable();
            $table->float('transactionAmount', 20, 2)->nullable();
            $table->string('transactionId')->unique()->nullable();
            $table->string('transactionDate')->nullable();
            $table->timestamp('payment_agent_timestamp')->nullable();
            $table->timestamp('API_timestamp')->nullable();
            $table->string('paymentTypeId')->nullable();
            $table->string('locale')->nullable();
            $table->string('dateFormat')->nullable();
            $table->string('receiptNumber')->nullable();
            $table->string('sync')->nullable();
            $table->text('comment')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('api_transactions');
    }
}
