<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class ApprovalRecord extends Model
{
    use HasFactory;
    protected $fillable = ['loan_id', 'user_id', 'adjusted_amount', 'comments', 'approval_level'];
    public function loan()
    {
        return $this->belongsTo(Loan::class, 'loan_id');
    }
    public function user()
    {
        return $this->belongsTo(User::class, 'user_id');
    }
}
