<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class APITransaction extends Model
{
    use HasFactory;

    protected $table = 'api_transactions';

    protected $fillable =[
        'payment_agent',
        'accountNumber',
        'name',
        'phoneNumber',
        'transactionAmount', 
        'transactionId',
        'transactionDate',
        'payment_agent_timestamp',
        'API_timestamp',
        'paymentTypeId',
        'locale',
        'dateFormat',
        'receiptNumber',
        'sync',
        'comment',
    ];

    public function sync_color($status)
    {
        if($status == "EB_SYNC_FAILED"){
            return "text-danger";
        }

        if($status == "EB_SYNC_OK"){
            return "text-success";
        }

        if($status == "TEST_OK"){
            return "text-info";
        }

        return "";
    }

    public function cachedUser(){
        return $this->belongsTo(CachedUser::class, 'accountNumber','account_number');
    }
}
