<?php

namespace App\Http\Controllers\Auth;

use App\Http\Controllers\Controller;
use App\Providers\RouteServiceProvider;
use Illuminate\Foundation\Auth\AuthenticatesUsers;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Session;
use Illuminate\Validation\ValidationException;
use App\Models\User;

class LoginController extends Controller
{
    use AuthenticatesUsers;

    protected $redirectTo = RouteServiceProvider::HOME;

    public function __construct()
    {
        $this->middleware('guest')->except('logout');
    }

    protected function credentials(Request $request)
    {
        $loginField = filter_var($request->input($this->username()), FILTER_VALIDATE_EMAIL) ? 'email' : 'phone';

        $credentials = [
            $loginField => $request->input($this->username()),
            'password' => $request->input('password'),
            'is_active' => 1 // add check for is_active column
        ];

        return $credentials;
    }

    protected function sendFailedLoginResponse(Request $request)
    {
        $email_user = User::where('email', $request->{$this->username()})->first();
        $account_user = User::where('phone', $request->{$this->username()})->first();

        if ($email_user || $account_user) {
            $user = $email_user ?? $account_user;

            if ($user && !$user->is_active) {
                throw ValidationException::withMessages([
                    $this->username() => [trans('This Account is disabled. Contact Nzuri administration')],
                ]);
            }
        }

        throw ValidationException::withMessages([
            $this->username() => [trans('auth.failed')],
        ]);
    }

    public function username()
    {
        return 'login';
    }

    // Function to generate CAPTCHA
    public function showLoginForm()
    {
        $captcha = $this->generateCaptcha();
        Session::put('captcha', $captcha);
        return view('auth.login', ['captcha' => $captcha]);
    }

    private function generateCaptcha()
    {
        return substr(str_shuffle('ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789'), 0, 6);
    }

    // Validate CAPTCHA
    public function validateCaptcha(Request $request)
    {
        $captcha = $request->input('captcha');
        $storedCaptcha = Session::get('captcha');

        if ($captcha !== $storedCaptcha) {
            throw ValidationException::withMessages([
                'captcha' => ['The CAPTCHA code is incorrect.'],
            ]);
        }
    }
}
