<?php

namespace App\Http\Controllers\API;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Tymon\JWTAuth\Facades\JWTAuth;
use Illuminate\Support\Facades\Validator;
use App\Models\APITransaction;

class TransactionController extends Controller
{

    public function __construct()
    {
    }

    public function transaction(Request $request)
    {
        $token = JWTAuth::parseToken();
        $user = $token->authenticate();

        if ($user->api_token_status === 0) {
            return response()->json(['status' => 'error', 'message' => 'Token is disabled',], 403);
        }

        $validator = Validator::make($request->all(), [
            'accountNumber' => 'required',
            'transactionAmount' => 'required|numeric',
            'transactionDate' => 'required|date',
            'transactionId' => 'required'
        ]);

        if ($validator->fails()) {
            return  response()->json(['status' => 'error', 'message' => 'Validation errors', 'errors' => $validator->errors()], 400);
        }

        $accountNumber = $request['accountNumber'];
        $transactionAmount = $request['transactionAmount'];
        $transactionDate = $request['transactionDate'];

        $last_id = APITransaction::orderBy('id', 'desc')->first();
        $recepte_no = ($last_id == null) ? 1 : $last_id->id + 1;

        $receiptNumber = "API" . str_pad($recepte_no, 7, 0, STR_PAD_LEFT);
        $accountNumber = str_replace("NT", "", strtoupper($accountNumber));

        $jsonPayload = [
            "locale" => "en",
            "dateFormat" => "dd MMMM yyyy",
            "transactionDate" => date("d M Y", strtotime($transactionDate)),
            "transactionAmount" => $transactionAmount,
            "paymentTypeId" => "15",
            "accountNumber" => $accountNumber,
            "receiptNumber" => $receiptNumber,
        ];

        $to_save = $jsonPayload;
        $to_save['API_timestamp'] = date('Y-m-d H:i:s');
        $to_save['payment_agent'] = $user->name;
        $to_save['payment_agent_timestamp'] = $transactionDate;
        $to_save['transactionId'] = $request['transactionId'];
        $to_save['name'] = $request['name'] ?? "";
        $to_save['phoneNumber'] = $request['phoneNumber'] ?? "";
        $to_save['sync'] = "EB_SYNC_PENDING";
        $to_save['comment'] = "Pending";

        $APITransaction = APITransaction::create($to_save);

        // If payment agent is set to TEST
        if ($user->environment === 'TEST') {
            $APITransaction->sync = "TEST_OK";
            $APITransaction->comment = "Testing Successful";
            $APITransaction->save();
        }


        return response()->json(['status' => 'success', 'message' => 'Transaction successfully posted'], 200);
    }


    public function flexipay(Request $request)
    {
        $user = $request->user;

        if ($user->api_token_status === 0) {
            return response()->json(['status_code' => '58', 'status_desc' => 'Authentication failed Authentication failed (Token is disabled)',], 403);
        }

        $validator = Validator::make($request->all(), [
            'customer_number' => 'required',
            'amount' => 'required'
        ]);

        if ($validator->fails()) {
            return  response()->json(['status_code' => '04', 'status_desc' => 'Invalid or amount not supplied', 'errors' => $validator->errors()], 400);
        }

        $accountNumber = $request['customer_number'];

        // Check if there is a dash in the customer_number
        if (strpos($accountNumber, '-') !== false) {
            // Split the string on the dash and take the first part
            $accountNumber = explode('-', $accountNumber)[0];
        }
        
        $transactionAmount = $request['amount'];
        $transactionDate = date('Y-m-d H:i:s');
        $customer_name = $request['customer_name'] ?? "";
        $trasactionId = $request['request_reference'];
        $phoneNumber = $request['location'] ?? "";

        $last_id = APITransaction::orderBy('id', 'desc')->first();
        $recepte_no = ($last_id == null) ? 1 : $last_id->id + 1;

        $receiptNumber = "API" . str_pad($recepte_no, 7, 0, STR_PAD_LEFT);
        $accountNumber = str_replace("NT", "", strtoupper($accountNumber));

        $jsonPayload = [
            "locale" => "en",
            "dateFormat" => "dd MMMM yyyy",
            "transactionDate" => date("d M Y", strtotime($transactionDate)),
            "transactionAmount" => $transactionAmount,
            "paymentTypeId" => "15",
            "accountNumber" => $accountNumber,
            "receiptNumber" => $receiptNumber,
        ];

        $to_save = $jsonPayload;
        $to_save['API_timestamp'] = date('Y-m-d H:i:s');
        $to_save['payment_agent'] = $user->name;
        $to_save['payment_agent_timestamp'] = $transactionDate;
        $to_save['transactionId'] = $trasactionId;
        $to_save['name'] =  $customer_name;
        $to_save['phoneNumber'] = $phoneNumber;

        if ($user->environment === 'TEST') {
            $to_save['sync'] = "TEST_OK";
            $to_save['comment'] = "Testing Successful";
        } else {
            $to_save['sync'] = "EB_SYNC_PENDING";
            $to_save['comment'] = "Pending";
        }

        $APITransaction = APITransaction::create($to_save);

        return response()->json([
            'status_code' => '00',
            'status_desc' => 'Completed successfully',
            'external_reference' => $receiptNumber,
            'flexipay_ref_num' => $trasactionId,
        ], 200);
    }
}
