<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use App\Models\APITransaction;
use Illuminate\Support\Facades\Http;
use App\Models\CachedUser;
use Illuminate\Support\Facades\DB;
use Carbon\Carbon;


class CollateralPostToEbanqr extends Command
{
    protected $signature = 'CollateralPostToEbanqr:cron';

    protected $description = 'Post loan application to Ebanqr';

    private $http_headers;

    private $url;

    public function __construct()
    {
        parent::__construct();

        $this->http_headers = [
            'Authorization' => env('EB_AUTHORIZATION'),
            'Accept' => env('EB_ACCEPT'),
            'api_key' => env('EB_API_KEY'),
            'eBanqr-Platform-TenantID' => env('EB_TENANTID'),
        ];
        $this->url = env('EB_URL');
    }

    public function handle()
    {
        echo "{$this->signature} is running \n";

        $collateral = DB::table('loan_collateral')
            ->where('sync', '=', 0)
            ->get();

        foreach ($collateral as $c) {

            $loan = DB::table('loans')
                ->where('id', '=', $c->loan_id)
                ->get()
                ->first();

            $to_post = [
                "collateralTypeId" => $c->collateral_type,
                "value" => $c->value,
                "dateFormat" => "dd MMMM yyyy",
                "locale" => "en",
                "description" => $c->description,
            ];

            echo "Syncing collateral {$c->collateral_name} \n";

            $response = Http::withHeaders($this->http_headers)
                ->withBody(json_encode($to_post), 'application/json')
                ->post("{$this->url}/loans/{$loan->loan_id}/collaterals");


            if($response->ok()) {
                $api_response = json_decode($response, true);
                $affected = DB::table('loan_collateral')
                    ->where('id', $c->id)
                    ->update(['collateral_id' => $api_response['resourceId'], 'sync' => 1]);
                if($affected == 1)
                {
                    echo "The loan application was updated in the database";
                } else {
                    echo "The loan was created in Ebanqr but not updated the database ";
                }
            }

        }


        echo "\n{$this->signature} is finished running \n";
    }
}
